/*------------------------------------------------------------------------------------
   Name: TMS-Osc.mq4
   Copyright 2010, Xaphod, http://forexwhiz.appspot.com
   
   Description: MTF Oscillator for the Trading Made Simple System.
                Similar to TDI RSI Signal Line and Trade Signal Line.
                Requires TMS_Osc.ex4 to be installed.
                	          
   Change log: 
       2011-05-22. Xaphod, v1.01
          - Removed dependancy on external indicator TMS-Osc.ex4
          - Fixed repaint of current HTF bar
       2011-05-16. Xaphod, v1.00 
          - First Release 
-------------------------------------------------------------------------------------*/
// Indicator properties
#property copyright "Copyright  2010, Xaphod"
#property link      "http://forexwhiz.appspot.com"

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 Red
#property indicator_width1 1
#property indicator_color2 Green
#property indicator_width2 1
#property indicator_level1 32
#property indicator_level2 50
#property indicator_level3 68
#property indicator_levelstyle STYLE_DOT
#property indicator_levelcolor DimGray

//#include <xDebug.mqh>

// Constant definitions
#define INDICATOR_NAME "TMS-Osc"
#define INDICATOR_VERSION "1.01"
#define INDICATOR_DISP_VC "1.01, 2011, Xaphod"
//#define TMS_INDI "TMS-Osc"


// Indicator parameters
extern string    Indi.Version= INDICATOR_DISP_VC;
extern string    TimeFrame.Settings="";
extern int       TimeFrame.TF=0;            // Timeframe: 0,1,5,15,30,60,240,1440 etc. Current Timeframe=0. 
extern int       TimeFrame.Auto=1;          // Automatically select higher TF. M15 and M30 -> H1. Off=0, 1st HTF=1, 2nd HTF=2
extern bool      TimeFrame.Repaint=True;    // Repaint the bars of the open higher time-frame candle 
extern string    RSI.Settings="";
extern int       RSI.Period=13;             // RSI Period
extern int       RSI.Price=PRICE_CLOSE;     // RSI Price Type: CLOSE=0, OPEN=1, HIGH=2, LOW=3, MEDIAN=4, TYPICAL=5, WEIGHTED=6
extern string    RSISignal.Settings="";
extern int       RSISignal.Period=2;        // RSI Signal MA-Filter Period
extern int       RSISignal.Mode=MODE_SMA;   // MA-Filter Method: SMA=0, EMA=1, SMMA=2, LWMA=4
extern string    TradeSignal.Settings="";
extern int       TradeSignal.Period=7;      // Trade Signal MA-Filter Period
extern int       TradeSignal.Mode=MODE_SMA; // MA-Filter Method: SMA=0, EMA=1, SMMA=2, LWMA=4


// Global module varables
double gadRSISig[];
double gadTradeSig[];

double gadRSI[];
double gadRMAFast[];
double gadRMASlow[];

int giRepaintBars;
int giTimeFrame;

//-----------------------------------------------------------------------------
// function: init()
// Description: Custom indicator initialization function.
//-----------------------------------------------------------------------------
int init() {
  // Set buffers
  SetIndexStyle(0, DRAW_LINE);
  SetIndexBuffer(0, gadTradeSig);
  SetIndexLabel(0,"Trade Signal");
  SetIndexStyle(1, DRAW_LINE);
  SetIndexBuffer(1, gadRSISig);
  SetIndexLabel(1,"RSI Signal");   
  
  // Set Timeframe
  switch(TimeFrame.Auto) {
    case 1: 
      giTimeFrame=NextHigherTF(TimeFrame.TF); 
      giRepaintBars=giTimeFrame/Period()+2;     
    break;
    case 2: 
      giTimeFrame=NextHigherTF(NextHigherTF(TimeFrame.TF));
      giRepaintBars=giTimeFrame/Period()+2;
    break;
    default: 
      giTimeFrame=TimeFrame.TF;
      giRepaintBars=0;
    break;
  }
  
  // Name & Stuff
  IndicatorShortName(INDICATOR_NAME+"("+TF2Str(giTimeFrame)+")");
  IndicatorDigits(1);
  return(0);
}

//-----------------------------------------------------------------------------
// function: deinit()
// Description: Custom indicator deinitialization function.
//-----------------------------------------------------------------------------
int deinit() {
   return (0);
}


///-----------------------------------------------------------------------------
// function: start()
// Description: Custom indicator iteration function.
//-----------------------------------------------------------------------------
int start() {
  int iNewBars;
  int iCountedBars; 
  int i;  

  // Get unprocessed ticks
  iCountedBars=IndicatorCounted();
  if(iCountedBars < 0) return (-1); 
  if(iCountedBars>0) iCountedBars--;
  iNewBars=Bars-iCountedBars;
  
  // Set bars to redraw
  if (TimeFrame.Repaint && iNewBars<giRepaintBars)
    iNewBars=giRepaintBars;

  // Calc and draw TMS data
  CalcRSIMA(giTimeFrame);
  for(i=iNewBars; i>=0; i--) {
    gadRSISig[i]=gadRMAFast[iBarShift(Symbol(), giTimeFrame, Time[i])];
    gadTradeSig[i]=gadRMASlow[iBarShift(Symbol(), giTimeFrame, Time[i])];
  }    
  return(0);
}
//+------------------------------------------------------------------+


//-----------------------------------------------------------------------------
// function: CalcRSIMA()
// Description: Calculate the RSI MAs
//-----------------------------------------------------------------------------
void CalcRSIMA(int iTimeFrame) {
  int i;
  int iCalcBars;
  datetime tTimeArray[];

  // Init arrays 
  ArrayCopySeries(tTimeArray,MODE_TIME,Symbol(),iTimeFrame); 
  iCalcBars=ArraySize(tTimeArray);
  ArraySetAsSeries(gadRSI,true);
  ArraySetAsSeries(gadRMAFast,true);
  ArraySetAsSeries(gadRMASlow,true);
  ArrayResize(gadRSI,iCalcBars);
  ArrayResize(gadRMAFast,iCalcBars);
  ArrayResize(gadRMASlow,iCalcBars);  
  // Calc HTF data
  for (i=iCalcBars; i>=0; i--) {  
    gadRSI[i]=iRSI(Symbol(),iTimeFrame,RSI.Period,RSI.Price,i);      
  }
  for (i=iCalcBars; i>=0; i--) {
    gadRMAFast[i]=iMAOnArray(gadRSI,0,RSISignal.Period,0,RSISignal.Mode,i);
    gadRMASlow[i]=iMAOnArray(gadRSI,0,TradeSignal.Period,0,TradeSignal.Mode,i);
  }
  return(0);
}

//-----------------------------------------------------------------------------
// function: TF2Str()
// Description: Convert time-frame to a string
//-----------------------------------------------------------------------------
string TF2Str(int iPeriod) {
  switch(iPeriod) {
    case PERIOD_M1: return("M1");
    case PERIOD_M5: return("M5");
    case PERIOD_M15: return("M15");
    case PERIOD_M30: return("M30");
    case PERIOD_H1: return("H1");
    case PERIOD_H4: return("H4");
    case PERIOD_D1: return("D1");
    case PERIOD_W1: return("W1");
    case PERIOD_MN1: return("MN1");
    default: return("M"+iPeriod);
  }
}

//-----------------------------------------------------------------------------
// function: NextHigherTF()
// Description: Select the next higher time-frame. 
//              Note: M15 and M30 both select H1 as next higher TF. 
//-----------------------------------------------------------------------------
int NextHigherTF(int iPeriod) {
  if (iPeriod==0) iPeriod=Period();
  switch(iPeriod) {
    case PERIOD_M1: return(PERIOD_M5);
    case PERIOD_M5: return(PERIOD_M15);
    case PERIOD_M15: return(PERIOD_H1);
    case PERIOD_M30: return(PERIOD_H1);
    case PERIOD_H1: return(PERIOD_H4);
    case PERIOD_H4: return(PERIOD_D1);
    case PERIOD_D1: return(PERIOD_W1);
    case PERIOD_W1: return(PERIOD_MN1);
    case PERIOD_MN1: return(PERIOD_MN1);
    default: return(Period());
  }
}




